#pragma once

#include <drive/backend/data/common/serializable.h>

class TInvalidateMarkupTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    static TString Type() {
        return "invalidate_photo_markup_tag";
    }

public:
    using TBase::TBase;

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Rewrite;
    }

    bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

private:
    static TFactory::TRegistrator<TInvalidateMarkupTag> Registrator;
};
