#pragma once

#include <drive/backend/actions/administrative.h_serialized.h>
#include <drive/backend/data/common/serializable.h>
#include <drive/backend/database/transaction/assert.h>
#include <drive/backend/roles/permissions.h>

#include <rtline/util/types/field.h>

class TTaggedObject;

namespace NDrivematics {
    class IChain {
    public:
        template<class TObjectid>
        static bool DoRemove(TMaybe<TTaggedObject> taggedUser, const TSet<TObjectid>& ids, TAdministrativeAction::EEntity entity, const TString& userId, const NDrive::IServer& server, NDrive::TEntitySession& tx);
    };

    class TACLTag;
    class TACLSaver {
    private:
        TAtomicSharedPtr<TACLTag> TagImpl;
        TDBTag TdbTag;

    public:
        TACLSaver(class TDBTag&& aclTag);
        TACLTag* operator->();
        operator class TDBTag& ();
    };

    class TACLTag: public IJsonSerializableTag, IChain {
    public:
        using TObjectsIds = TSet<TString>;
        using TDBTagPtrImpl = TAtomicSharedPtr<TACLTag>;

        enum class ERemoveEntityPolicy {
            Default,
            Reference,
            Object
        };

    public:
        class TDescription: public TTagDescription, IChain {
        private:
            using TBase = TTagDescription;

        public:
            using TPtrImpl = TAtomicSharedPtr<TDescription>;
            using TConstPtrImpl = TAtomicSharedPtr<const TDescription>;

        public:
            bool CheckPermission(const TAdministrativeAction::EEntity& entity, const TAdministrativeAction::EAction& action, TUserPermissions::TPtr permissions) const;
            const TObjectsIds& GetEntityObjects(const TAdministrativeAction::EEntity& entity, TUserPermissions::TPtr permissions, bool force = false) const;
            [[nodiscard]] bool AddEntityObject(const TAdministrativeAction::EEntity& entity, const TString& objectId, TUserPermissions::TPtr permissions, TMessagesCollector& errors);
            [[nodiscard]] bool RemoveEntityObjects(const TAdministrativeAction::EEntity& entity, const TObjectsIds& ids, TUserPermissions::TPtr permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx, ERemoveEntityPolicy policy = ERemoveEntityPolicy::Default);

        public:
            using TBase::TBase;

            virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        private:
            virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
            virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

        private:
            TMap<TAdministrativeAction::EEntity, TObjectsIds> CompanyObjects;

            static TFactory::TRegistrator<TDescription> Registrator;
        };

    public:
        virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
            return { NEntityTagsManager::EEntityType::User };
        }

        virtual EUniquePolicy GetUniquePolicy() const override {
            return EUniquePolicy::Rewrite;
        }

    public:
        static TString GetOrganizationAffiliationCompanyName(const TString& userId, const NDrive::IServer& server, NDrive::TEntitySession& tx);
        static TDescription::TPtrImpl GetOrCreateACLTagDescription(const TString& userId, const NDrive::IServer& server);
        static TDescription::TPtrImpl GetCompanyTagDescription(const TString& userId, const NDrive::IServer& server);
        static TDBTag CreateACLTag(TACLTag::TDescription::TConstPtrImpl tagDescriptionPtrImpl, const TString& userId, const NDrive::IServer& server);
        static TACLSaver GetACLTag(TUserPermissions::TPtr permissions, NDrive::TEntitySession& tx, const NDrive::IServer& server);

    public:
        bool CheckPermission(const TAdministrativeAction::EEntity&  /*entity*/, const TAdministrativeAction::EAction&  /*action*/, TUserPermissions::TPtr  /*permissions*/) const;
        const TObjectsIds& GetEntityObjects(const TAdministrativeAction::EEntity& entity, TUserPermissions::TPtr permissions, bool force = false) const;
        [[nodiscard]] bool AddEntityObject(const TAdministrativeAction::EEntity& entity, const TString& objectId, TMessagesCollector& errors, TUserPermissions::TPtr permissions);
        [[nodiscard]] bool RemoveEntityObjects(const TAdministrativeAction::EEntity& entity, const TObjectsIds& ids, TUserPermissions::TPtr permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx, bool force = false);

        static ui64 GetUid(const TString& companyName) {
            return FnvHash<ui64>(companyName);
        }

    private:
        using TBase = IJsonSerializableTag;
        using TBase::TBase;

    public:
        static const TString TypeName;

    private:
        virtual void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
        virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

        [[nodiscard]] virtual bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;

        NDrive::TScheme GetScheme(const NDrive::IServer* server ) const override;

    private:
        TMap<TAdministrativeAction::EEntity, TObjectsIds> UserObjects;

        static TFactory::TRegistrator<TACLTag> Registrator;
    };
}
