#pragma once

#include "delivery.h"
#include "offer.h"
#include "tag_with_subtags.h"

class TLongTermCarDeliveryTag: public TCarDeliveryTag {
private:
    using TBase = TCarDeliveryTag;

public:
    static TString Type() {
        return "long_term_car_delivery_tag";
    }

public:
    using TBase::TBase;

    bool OnBeforePerform(TDBTag& /*self*/, const TUserPermissions& /*permissions*/, const NDrive::IServer* /*server*/, NDrive::TEntitySession& session) override;
    virtual bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

protected:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

private:
    R_FIELD(TString, OfferId);
    R_FIELD(TString, UserId);

    DECLARE_FIELDS(
        Field(OfferId, "offer_id"),
        Field(UserId, "user_id")
    );

private:
    static TFactory::TRegistrator<TLongTermCarDeliveryTag> Registrator;
};

class TLongTermOfferHolderTag: public TOfferHolderUserTag, public TTagWithSubtags {
private:
    using TBase = TOfferHolderUserTag;

public:
    class TDescription: public TTagWithSubtags::TDescription {
    private:
        using TBase = TTagWithSubtags::TDescription;

    public:
        using TBase::TBase;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        R_FIELD(TString, ChildSeatTag);
        R_FIELD(TString, CommunicationTag);
        R_FIELD(bool, CheckDeposit, false);
        R_FIELD(bool, StartBillingTask, false);

        DECLARE_FIELDS(
            Field(ChildSeatTag, "child_seat_tag"),
            Field(CommunicationTag, "communication_tag"),
            Field(CheckDeposit, "check_deposit"),
            Field(StartBillingTask, "start_billing_task")
        );
    };

public:
    static const TString Preparation;

public:
    static TOptionalDBTags RestoreOfferHolderTags(const TString& behaviourConstructorId, const NDrive::IServer& server, NDrive::TEntitySession& session);
    static bool AssignCarId(const TDBTag& tag, const TString& carId, const TString& tagName, const TUserPermissions& permissions, const NDrive::IServer& server, NDrive::TEntitySession& session, bool overwrite = false);

    static TString Type() {
        return "long_term_offer_holder_tag";
    }

public:
    using TBase::TBase;

    bool IsPreparation() const;

    const TString& GetCarId() const;
    virtual const TString& GetStage(const TTaggedObject* object) const override;

    virtual bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    virtual bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    virtual bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    virtual bool OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;
    virtual bool OnAfterEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* eContext) const override;
    virtual bool OnBeforeUpdate(const TDBTag& self, ITag::TPtr to, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

protected:
    bool RemoveCommunicationTag(TUserPermissionsConstPtr permissions, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool StartBillingTask(const NDrive::IServer* server, NDrive::TEntitySession& session) const;

    NDrive::NProto::TOfferHolderTag DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const NDrive::NProto::TOfferHolderTag& proto) override;

    bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;

private:
    R_OPTIONAL(TString, CarId);
    R_OPTIONAL(TVector<TGeoCoord>, DeliveryArea);
    R_OPTIONAL(TString, DeliveryLocationName);
    R_OPTIONAL(TGeoCoord, DeliveryLocation);
    R_OPTIONAL(TInstant, Since);
    R_OPTIONAL(bool, Autoassigned);

    R_FIELD(TString, CommunicationTagId);

    DECLARE_FIELDS(
        Field(Autoassigned, "autoassigned"),
        Field(CarId, "car_id"),
        Field(DeliveryArea, "delivery_area"),
        Field(DeliveryLocationName, "delivery_location_name"),
        Field(DeliveryLocation, "delivery_location"),
        Field(Since, "since"),

        Field(CarTagIds, "car_tag_ids"),
        Field(UserTagIds, "user_tag_ids"),
        Field(CommunicationTagId, "communication_tag_id")
    );

private:
    static TFactory::TRegistrator<TLongTermOfferHolderTag> Registrator;
};
