#pragma once

#include "device_tags.h"

#include <drive/backend/areas/location.h>
#include <drive/backend/tags/tags_manager.h>

class TModelTag : public TDeviceTagRecord {
public:
    class TDescription : public TTagDescription {
    public:
        const NDrive::TLocationTags& GetAllowRidingTags() const {
            return !AllowRidingTags.empty() ? AllowRidingTags : NDrive::DefaultAllowRidingLocationTags;
        }
        const NDrive::TLocationTags& GetAllowDropTags() const {
            return !AllowDropTags.empty() ? AllowDropTags : NDrive::DefaultAllowDropLocationTags;
        }
        const NDrive::TLocationTags& GetForceAllowDropTags() const {
            return !ForceAllowDropTags.empty() ? ForceAllowDropTags : NDrive::DefaultAllowForcedDropLocationTags;
        }
        const NDrive::TLocationTags& GetDenyDropTags() const {
            return !DenyDropTags.empty() ? DenyDropTags : NDrive::DefaultDenyDropLocationTags;
        }
        const NDrive::TLocationTags& GetPoiTags() const {
            return !PoiTags.empty() ? PoiTags : NDrive::DefaultPoiLocationTags;
        }
        const TSet<TString>& GetInsuranceTypes() const {
            return InsuranceTypes;
        }

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        NDrive::TLocationTags AllowRidingTags;
        NDrive::TLocationTags AllowDropTags;
        NDrive::TLocationTags DenyDropTags;
        NDrive::TLocationTags ForceAllowDropTags;
        NDrive::TLocationTags PoiTags;
        TSet<TString> InsuranceTypes;
    };

public:
    static IEntityTagsManager::TExpectedTag Get(const TString& objectId, const NDrive::IServer& server);
    static const NDrive::TLocationTags& GetAllowRidingTags(const TConstDBTag& modelTag, const NDrive::IServer& server);
    static const NDrive::TLocationTags& GetAllowDropTags(const TConstDBTag& modelTag, const NDrive::IServer& server);
    static const NDrive::TLocationTags& GetPoiLocationTags(const TConstDBTag& modelTag, const NDrive::IServer& server);
    static TAtomicSharedPtr<const TDescription> GetDescription(const TConstDBTag& modelTag, const NDrive::IServer& server);
    static TMaybe<TSet<TString>> GetInsuranceTypes(const TConstDBTag& modelTag, const NDrive::IServer& server);

public:
    using TDeviceTagRecord::TDeviceTagRecord;

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    static TString Type() {
        return "model_tag";
    }
};
