#include "notifications_abstract.h"

NDrive::TScheme INotificationsTagDescription::GetScheme(const NDrive::IServer* server) const {
    auto scheme = TBase::GetScheme(server);
    scheme.Add<TFSJson>("activity_interval", "Диапазон активности");
    scheme.Add<TFSBoolean>("enabled", "Рассылка включена").SetDefault(Enabled);
    scheme.Add<TFSBoolean>("external_enabled", "Redirecting to external systems enabled").SetDefault(ExternalEnabled);
    CommunicationChannelSettings.FillScheme(scheme);
    scheme.Add<TFSBoolean>("use_origin", "Слать туда, где пользователь зарегистрировался").SetDefault(UseOrigin);
    scheme.Add<TFSBoolean>("fetch_external_user_id_from_history_sessions", "Использовать externalUserId из завершенных сессий").SetDefault(FetchExternalUserIdFromHistorySessions);
    return scheme;
}

bool INotificationsTagDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) {
    JREAD_BOOL_OPT(jsonMeta, "push_enabled", Enabled);
    const auto& activityInterval = jsonMeta["activity_interval"];
    if (activityInterval.IsDefined()) {
        ActivityInterval.ConstructInPlace();
        if (!ActivityInterval->DeserializeFromJson(activityInterval)) {
            return false;
        }
    }
    return
        TBase::DoDeserializeMetaFromJson(jsonMeta) &&
        NJson::ParseField(jsonMeta["enabled"], Enabled) &&
        NJson::ParseField(jsonMeta["external_enabled"], ExternalEnabled) &&
        NJson::ParseField(jsonMeta["use_origin"], UseOrigin) &&
        NJson::ParseField(jsonMeta["fetch_external_user_id_from_history_sessions"], FetchExternalUserIdFromHistorySessions) &&
        CommunicationChannelSettings.DeserializeFromJson(jsonMeta);
}

NJson::TJsonValue INotificationsTagDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue jsonMeta = TBase::DoSerializeMetaToJson();
    if (ActivityInterval) {
        jsonMeta["activity_interval"] = ActivityInterval->SerializeToJson();
    }
    NJson::InsertField(jsonMeta, "enabled", Enabled);
    NJson::InsertNonNull(jsonMeta, "external_enabled", ExternalEnabled);
    CommunicationChannelSettings.SerializeToJson(jsonMeta);
    NJson::InsertNonNull(jsonMeta, "use_origin", UseOrigin);
    NJson::InsertNonNull(jsonMeta, "fetch_external_user_id_from_history_sessions", FetchExternalUserIdFromHistorySessions);
    return jsonMeta;
}

void INotificationTag::FillScheme(NDrive::TScheme& scheme) const {
    scheme.Add<TFSNumeric>("deadline", "Не отсылать после... (timestamp UTC)").SetVisual(NDrive::TFSNumeric::EVisualType::DateTime);
    scheme.Add<TFSNumeric>("start", "Не отсылать до... (timestamp UTC)").SetVisual(NDrive::TFSNumeric::EVisualType::DateTime);
}

void INotificationTag::SerializeToJson(NJson::TJsonValue& json) const {
    TJsonProcessor::Write(json, "external_user_id", ExternalUserId, {""});
    TJsonProcessor::WriteInstant(json, "deadline", Deadline, TInstant::Max());
    TJsonProcessor::WriteInstant(json, "start", SendInstant, TInstant::Zero());
}

bool INotificationTag::DeserializeFromJson(const NJson::TJsonValue& json) {
    return (TJsonProcessor::Read(json, "deadline", Deadline, false)
            && TJsonProcessor::Read(json, "start", SendInstant, false)
            && TJsonProcessor::Read(json, "external_user_id", ExternalUserId, false));
}
