#pragma once

#include "notifications_abstract.h"

class TUserMailTag: public INotificationTagBase<NDrive::NProto::TUserMailTagData> {
public:
    class TDescription: public INotificationsTagDescription {
    public:
        struct TField {
            TField(const TString& id, const TString& name, const TString& defaultValue)
                : Id(id)
                , Name(name)
                , DefaultValue(defaultValue)
            {
            }

            TString Id;
            TString Name;
            TString DefaultValue;
        };

    private:
        using TBase = INotificationsTagDescription;

    private:
        R_FIELD(TString, TemplateId);
        R_FIELD(TVector<TField>, TemplateArgs);

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
        NJson::TJsonValue DoSerializeMetaToJson() const override;
    };

    struct TAttachInfo {
        TString Url;
        TString Filename;
        TString MimeType;

        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& json);
        static NDrive::TScheme GetScheme();
    };

    using TAttachments = TVector<TAttachInfo>;
    using TProtoAttachment = NDrive::NProto::TUserMailTagData::TAttachment;

private:
    using TBase = INotificationTagBase<NDrive::NProto::TUserMailTagData>;
    using TProtoField = NDrive::NProto::TUserMailTagData::TField;
    using TTemplateArgs = TMap<TString, TString>;

private:
    R_FIELD(TString, SessionId);
    R_FIELD(TTemplateArgs, TemplateArgs, {});
    R_FIELD(TAttachments, Attachments);

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TUserMailTag> Registrator;

public:
    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;
    TProto DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;
    virtual bool OnBeforeAdd(const TString& /*objectId*/, const TString& /*userId*/, const NDrive::IServer* /*server*/, NDrive::TEntitySession& /*session*/) override;

    EUniquePolicy GetUniquePolicy() const override;
    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override;

    virtual TExpected<NDrive::INotifier::TMessage, TString> BuildMessage(ELocalization locale, const NDrive::IServer& server, const INotificationsTagDescription& desc, const TUserContacts& contacts) const override;
};

class TSupportAITag: public INotificationTagBase<NDrive::NProto::TSupportAITagData> {
private:
    using TBase = INotificationTagBase<NDrive::NProto::TSupportAITagData>;
    using TDescriptionBase = INotificationsTagDescription;

public:
    class TDescription: public TDescriptionBase {
    public:
        using TBase = INotificationsTagDescription;
        using TFeatures = TMap<TString, TString>;
    private:
        R_FIELD(TFeatures, DefaultFeatures);
        R_FIELD(bool, SaveResult, false);

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
    };

private:
    R_FIELD(TDescription::TFeatures, Features);

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TSupportAITag> Registrator;

public:
    using TBase::TBase;
    NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    EUniquePolicy GetUniquePolicy() const override;
    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override;
    TExpected<NDrive::INotifier::TMessage, TString> BuildMessage(ELocalization locale, const NDrive::IServer& server, const INotificationsTagDescription& desc, const TUserContacts& contacts) const override;

protected:
    TProto DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;
};

class TUserMessageTagBase: public INotificationTagBase<NDrive::NProto::TUserMessageTagData> {
private:
    using TBase = INotificationTagBase<NDrive::NProto::TUserMessageTagData>;

public:
    using TBase::TBase;

    class TDescription: public INotificationsTagDescription {
    private:
        using TBase = INotificationsTagDescription;

    private:
        R_FIELD(NJson::TJsonValue, AdditionalInfo);
        R_FIELD(TString, MessageText);
        R_FIELD(TString, Title);

    public:
        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
    };

public:
    void AddMacro(const TString& name, const TString& value) {
        Macros[name] = value;
    }

    const TString& GetMessageText() const {
        return MessageText;
    }
    void SetMessageText(const TString& value) {
        MessageText = value;
    }

    const NJson::TJsonValue& GetAdditionalInfo() const {
        return AdditionalInfo;
    }
    void SetAdditionalInfo(NJson::TJsonValue&& value) {
        AdditionalInfo = std::move(value);
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return {NEntityTagsManager::EEntityType::User};
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    virtual TExpected<NDrive::INotifier::TMessage, TString> BuildMessage(ELocalization locale, const NDrive::IServer& server, const INotificationsTagDescription& desc, const TUserContacts& contacts) const override;

private:
    TMap<TString, TString> Macros;
    TString MessageText;
    TString Title;
    NJson::TJsonValue AdditionalInfo;
};

class TUserSmsTag: public TUserMessageTagBase {
public:
    using TUserMessageTagBase::TUserMessageTagBase;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TUserSmsTag> Registrator;
    static TDescription::TFactory::TRegistrator<TDescription> DescriptionRegistrator;
};

class TUserWorldSmsTag: public TUserMessageTagBase {
public:
    using TUserMessageTagBase::TUserMessageTagBase;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TUserWorldSmsTag> Registrator;
    static TDescription::TFactory::TRegistrator<TDescription> DescriptionRegistrator;
};

class TUserPushTag: public TUserMessageTagBase {
public:
    using TUserMessageTagBase::TUserMessageTagBase;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TUserPushTag> Registrator;
    static TDescription::TFactory::TRegistrator<TDescription> DescriptionRegistrator;
};

class TServiceAppPushTag: public TUserMessageTagBase {
public:
    using TUserMessageTagBase::TUserMessageTagBase;

public:
    static const TString TypeName;
    static TFactory::TRegistrator<TServiceAppPushTag> Registrator;
    static TDescription::TFactory::TRegistrator<TDescription> DescriptionRegistrator;
};
