#pragma once

#include <drive/backend/offers/offers/abstract.h>

class IOfferContainer {
public:
    static ICommonOffer::TPtr RestoreOffer(const TObjectEvent<TConstDBTag>& ev) noexcept;

public:
    virtual ~IOfferContainer() = default;

    virtual ICommonOffer::TPtr GetOffer() const = 0;
    virtual const TString& GetStage(const TTaggedObject* object) const = 0;
    virtual NJson::TJsonValue GetStageReport(const TTaggedObject* object, const NDrive::IServer& server) const;
};
