#include "operation_area.h"

#include <drive/backend/areas/areas.h>
#include <drive/backend/database/drive_api.h>

#include <rtline/library/json/parse.h>

NDrive::TScheme TOperationAreaTag::TDescription::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TTagDescription::GetScheme(server);
    result.Add<TFSString>("title");
    result.Add<TFSString>("icon");
    result.Add<TFSString>("image");
    result.Add<TFSNumeric>("order");
    auto locationTags = server ? server->GetDriveAPI()->GetAreasDB()->GetAreaTags(TDuration::Max()) : NDrive::TLocationTags();
    result.Add<TFSVariants>("allow_drop_location_tags", "Location tags allowing car drop").SetVariants(locationTags).SetMultiSelect(true);
    result.Add<TFSVariants>("allow_riding_location_tags", "Location tags allowing riding").SetVariants(locationTags).SetMultiSelect(true);
    result.Add<TFSVariants>("force_allow_drop_location_tags", "Location tags allowing car force drop").SetVariants(locationTags).SetMultiSelect(true);
    result.Add<TFSVariants>("deny_drop_location_tags", "Location tags denying car drop").SetVariants(locationTags).SetMultiSelect(true);
    return result;
}

NJson::TJsonValue TOperationAreaTag::TDescription::GetReport() const {
    NJson::TJsonValue result;
    result["id"] = GetName();
    result["title"] = Title;
    result["icon"] = Icon;
    if (Image) {
        result["image"] = Image;
    }
    return result;
}

NJson::TJsonValue TOperationAreaTag::TDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue result = TTagDescription::DoSerializeMetaToJson();
    result["force_allow_drop_location_tags"] = NJson::ToJson(ForceAllowDropLocationTags);
    result["allow_drop_location_tags"] = NJson::ToJson(AllowDropLocationTags);
    result["allow_riding_location_tags"] = NJson::ToJson(AllowRidingLocationTags);
    result["deny_drop_location_tags"] = NJson::ToJson(DenyDropLocationTags);
    result["icon"] = Icon;
    result["image"] = Image;
    result["order"] = Order;
    result["title"] = Title;
    return result;
}

bool TOperationAreaTag::TDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& value) {
    return
        NJson::ParseField(value["force_allow_drop_location_tags"], AllowDropLocationTags) &&
        NJson::ParseField(value["allow_drop_location_tags"], AllowDropLocationTags) &&
        NJson::ParseField(value["allow_riding_location_tags"], AllowRidingLocationTags) &&
        NJson::ParseField(value["deny_drop_location_tags"], DenyDropLocationTags) &&
        NJson::ParseField(value["icon"], Icon) &&
        NJson::ParseField(value["image"], Image) &&
        NJson::ParseField(value["order"], Order) &&
        NJson::ParseField(value["title"], Title);
}

ITag::TFactory::TRegistrator<TOperationAreaTag> OperationAreaTagRegistrator(TOperationAreaTag::Type());
TTagDescription::TFactory::TRegistrator<TOperationAreaTag::TDescription> OperationAreaTagDescriptionRegistrator(TOperationAreaTag::Type());
