#pragma once

#include "device_tags.h"

#include <drive/backend/areas/location.h>

class TOperationAreaTag: public TDeviceTagRecord {
public:
    class TDescription: public TTagDescription {
    public:
        const NDrive::TLocationTags& GetForceAllowDropLocationTags() const {
            return ForceAllowDropLocationTags;
        }
        const NDrive::TLocationTags& GetAllowDropLocationTags() const {
            return AllowDropLocationTags;
        }
        const NDrive::TLocationTags& GetAllowRidingLocationTags() const {
            return AllowRidingLocationTags;
        }
        const NDrive::TLocationTags& GetDenyDropLocationTags() const {
            return DenyDropLocationTags;
        }
        ui32 GetOrder() const {
            return Order;
        }

        NJson::TJsonValue GetReport() const;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        NDrive::TLocationTags ForceAllowDropLocationTags;
        NDrive::TLocationTags AllowDropLocationTags;
        NDrive::TLocationTags AllowRidingLocationTags;
        NDrive::TLocationTags DenyDropLocationTags;

        TString Icon;
        TString Image;
        TString Title;
        ui32 Order = 0;
    };

public:
    using TDeviceTagRecord::TDeviceTagRecord;

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    static TString Type() {
        return "operation_area_tag";
    }
};
