#pragma once

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/library/json/parse.h>


class IOrganizationTag {
    R_FIELD(ui32, ParentId, 0);

public:
    void SerializeToJson(NJson::TJsonValue& json) const {
        NJson::InsertNonNull(json, "parent_id", ParentId);
    }
    bool DeserializeFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) {
        if (errors) {
            return NJson::ParseField(json, "parent_id", ParentId, true, *errors);
        }
        return NJson::ParseField(json, "parent_id", ParentId, true);
    }

    template<class TProto>
    void SerializeToProto(TProto& proto) const {
        proto.SetParentId(ParentId);
    }

    template<class TProto>
    bool DeserializeFromProto(const TProto& proto) {
        ParentId = proto.GetParentId();
        return true;
    }
    void AddScheme(NDrive::TScheme& scheme) const {
        scheme.Add<TFSNumeric>("parent_id", "Родительский кошелек").SetMin(0).SetRequired(true);
    }
};
