#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/parking_zones/manager.h>

#include <drive/library/cpp/parking/api/client.h>


class TParkingInfoTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    class TDescription : public TTagDescription {
    public:
        using TGroups = TMap<TString, TString>;

    public:
        const TGroups& GetGroups() const {
            return Groups;
        }
        ui32 GetCriticalUsageCount() const {
            return CriticalUsageCount;
        }
        ui32 GetRequiredSlotsCount() const {
            return RequiredSlotsCount;
        }
        bool ShouldUseFakeTokens() const {
            return UseFakeTokens;
        }
        const TSet<i64>& GetSkipAggregatorsOnRemove() const {
            return SkipAggregatorsOnRemove;
        }

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        TGroups Groups;
        ui32 CriticalUsageCount = 1;
        ui32 RequiredSlotsCount = 4;
        bool UseFakeTokens = false;
        TSet<i64> SkipAggregatorsOnRemove;
    };

    using TSlot = NDrive::TParkingAggregatorsManager::TSlot;

public:
    static TString DryRunTagName() {
        return "dry_run_parking_payment";
    }
    static TString TagName() {
        return "parking_payment";
    }

public:
    using TBase::TBase;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }
    virtual TString GetHRDescription() const override {
        return "Parking payment tag";
    }

    virtual bool OnBeforeAdd(const TString& objectId, const TString& /*userId*/, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    virtual bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;

    const TVector<TSlot>& GetSlots() const {
        return Slots;
    }
    TVector<TSlot>& GetSlots() {
        return Slots;
    }

    double GetCost(TInstant now) const;
    bool IsActive(TInstant now) const;

    NJson::TJsonValue ToJson() const;

protected:
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& result) const override;
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& data, TMessagesCollector* errors) override;

private:
    mutable TVector<TSlot> Slots;
};
