#include "permission_tags.h"
#include <drive/backend/database/drive_api.h>
#include <drive/backend/roles/manager.h>

NDrive::TScheme TAdditionalRolesTag::TDescription::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::GetScheme(server);
    if (server) {
        result.Add<TFSVariants>("roles", "Фильтр ролей").SetVariants(server->GetDriveAPI()->GetRolesManager()->GetRolesDB().GetCachedObjectsMap()).SetMultiSelect(true);
    } else {
        result.Add<TFSArray>("roles", "Фильтр ролей").SetElement<TFSString>();
    }
    return result;
}

NJson::TJsonValue TAdditionalRolesTag::TDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue jsonMeta = TBase::DoSerializeMetaToJson();
    NJson::InsertField(jsonMeta, "roles", RoleIds);
    return jsonMeta;
}

bool TAdditionalRolesTag::TDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) {
    return NJson::ParseField(jsonMeta, "roles", RoleIds, true)
        && TBase::DoDeserializeMetaFromJson(jsonMeta);
}

TDBActions TAdditionalRolesTag::GetActions(const TConstDBTag& self, const IDriveTagsManager& tagsManager, const TRolesManager& rolesManager, bool /*getPotential*/) const {
    Y_UNUSED(self);
    auto description = tagsManager.GetTagsMeta().GetDescriptionByName(GetName());
    auto descriptionImpl = dynamic_cast<const TAdditionalRolesTag::TDescription*>(description.Get());
    if (!descriptionImpl) {
        return {};
    }

    const TSet<TString> actionIds = rolesManager.GetRolesInfoDB().GetActions(descriptionImpl->GetRoleIds());

    TDBActions result;
    TMap<TString, TDBAction> additionalActions = rolesManager.GetActions(actionIds);
    for (auto&& [_, action] : additionalActions) {
        result.emplace_back(action);
    }
    return result;
}

