#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/common/temporary_tags.h>
#include <drive/backend/data/proto/tags.pb.h>

class TAdditionalRolesTag: public ISerializableTag<NDrive::NProto::TCommonTagData>, public IUserActionTag {
private:
    using TBase = ISerializableTag<NDrive::NProto::TCommonTagData>;

public:
    class TDescription: public TTagDescription {
    private:
        using TBase = TTagDescription;

    public:
        R_FIELD(TSet<TString>, RoleIds);

    private:
        static TFactory::TRegistrator<TDescription> Registrator;

    public:
        using TBase::TBase;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
    };

public:
    using TBase::TBase;

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    TDBActions GetActions(const TConstDBTag& self, const IDriveTagsManager& tagsManager, const TRolesManager& rolesManager, bool getPotential) const override;
};
