#pragma once

#include <drive/backend/data/offer.h>

class TRentalOffer;
class TRentalOfferHolderTag: public TOfferHolderTag {
private:
    using TBase = TOfferHolderTag;

public:
    class TDescription: public TTagDescription {
    public:
        using TTagDescription::TTagDescription;
    };

    using TRentalEvents = TVector<TObjectEvent<TConstDBTag>>;
    using TRentalTagNames = std::pair<TSet<TString>, TSet<TString>>;

public:
    static TOptionalDBTags RestoreOfferHolderTags(const TString& behaviourConstructorId, const NDrive::IServer& server, NDrive::TEntitySession& session);

    static TString Type() {
        return "rental_offer_holder_tag";
    }
    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::User };
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

public:
    using TBase::TBase;

    const TString& GetStage(const TTaggedObject* object) const override;

    bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnAfterRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnBeforeUpdate(const TDBTag& self, ITag::TPtr to, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    bool OnAfterUpdate(const TDBTag& self, ITag::TPtr toTag, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    static TMaybe<bool> LockOffer(TAtomicSharedPtr<TRentalOffer> offer, NDrive::TEntitySession& session);
    static bool LockCar(TAtomicSharedPtr<TRentalOffer> offer, NDrive::TEntitySession& session);
    static bool LockCar(const TString& carId, NDrive::TEntitySession& session);
    static bool LockUser(const TString& userId, NDrive::TEntitySession& session);
    static bool LockTwoCars(const TString& carId1, const TString& carId2, NDrive::TEntitySession& session);
    static TRentalTagNames GetRentalTagNamesByPermissions(const TUserPermissions& permissions);
    static bool Start(const TDBTag& selfContainer, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TString& sourceSessionMessage, const TString& carId);
    static TString GetPaidOfferStatus();

protected:
    bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;

private:
    bool ProcessPaidOffer(const TDBTag& selfContainer, const TString& userId, const NDrive::IServer* server,
                           NDrive::TEntitySession& session, const TString& sourceSessionMessage,
                           TAtomicSharedPtr<TRentalOffer> offer) const;
    static bool ProcessRentalStatusChanged(TAtomicSharedPtr<TRentalOffer> offer,
                                           const TString& previousStatus,
                                           const NDrive::IServer* server,
                                           NDrive::TEntitySession& session,
                                           const TString& userId,
                                           bool rentalCancelled = false);
    static bool CheckTagExists(const TDBTag& self, const NDrive::IServer* server, NDrive::TEntitySession& session);

private:
    R_FIELD(NJson::TJsonValue, OfferUpdateData);
    R_FIELD(TString, PreviousOfferStatus);

private:
    static TFactory::TRegistrator<TRentalOfferHolderTag> Registrator;
};
