#pragma once

#include <drive/backend/data/common/serializable.h>

#include <drive/backend/proto/tags.pb.h>
#include <drive/backend/tags/tag.h>

#include <rtline/util/types/field.h>

class TRentalServiceModeTag: public ISerializableTag<NDrive::NProto::TRentalServiceModeTag> {
private:
    using TBase = ISerializableTag<NDrive::NProto::TRentalServiceModeTag> ;

public:
    class TDescription: public TTagDescription {
    public:
        using TTagDescription::TTagDescription;
    };

public:
    using TBase::TBase;

    static TString Type() {
        return "rental_service_mode_tag";
    }
    bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;
    bool OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* evolutionContext) const override;

    TProto DoSerializeSpecialDataToProto() const override;
    bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

private:
    R_FIELD(TString, JobType);
    R_FIELD(TString, JobComment);
    R_FIELD(double, Mileage, 0.);
    R_FIELD(TInstant, Since);
    R_OPTIONAL(TInstant, Until);

public:
    DECLARE_FIELDS(
        Field(JobType, "job_type"),
        Field(JobComment, "job_comment"),
        Field(Mileage, "mileage"),
        Field(Since, "since")
    )

public:
    static TFactory::TRegistrator<TRentalServiceModeTag> Registrator;
    static TDescription::TFactory::TRegistrator<TDescription> DescriptionRegistrator;
};
