#include "service_tags.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/cars/hardware.h>

NDrive::TScheme TCarAttachmentAssignmentTag::TDescription::GetScheme(const NDrive::IServer* server) const {
    NDrive::TScheme result = TBase::GetScheme(server);
    result.Add<TFSVariants>("attachment_type", "Attachment type").InitVariants<EDocumentAttachmentType>();
    result.Add<TFSBoolean>("attachment_orientation", "True for attach and false for detach");
    return result;
}

NJson::TJsonValue TCarAttachmentAssignmentTag::TDescription::DoSerializeMetaToJson() const {
    NJson::TJsonValue jsonMeta = TBase::DoSerializeMetaToJson();
    NJson::InsertField(jsonMeta, "attachment_type", NJson::Stringify(AttachmentType));
    NJson::InsertField(jsonMeta, "attachment_orientation", AttachmentOrientation);
    return jsonMeta;
}

bool TCarAttachmentAssignmentTag::TDescription::DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) {
    return TBase::DoDeserializeMetaFromJson(jsonMeta)
        && NJson::ParseField(jsonMeta["attachment_type"], NJson::Stringify(AttachmentType))
        && NJson::ParseField(jsonMeta["attachment_orientation"], AttachmentOrientation)
    ;
}

bool TCarAttachmentAssignmentTag::OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx, const TEvolutionContext* evolutionContext) const {
    Y_UNUSED(to);
    Y_UNUSED(permissions);
    Y_UNUSED(evolutionContext);
    return OnBeforeExit(from.GetObjectId(), *Yensured(server), tx);
}

bool TCarAttachmentAssignmentTag::OnBeforeRemove(const TDBTag& self, const TString& /*userId*/, const NDrive::IServer* server, NDrive::TEntitySession& tx) {
    return OnBeforeExit(self.GetObjectId(), *Yensured(server), tx);
}

bool TCarAttachmentAssignmentTag::OnBeforeExit(const TString& objectId, const NDrive::IServer& server, NDrive::TEntitySession& tx) const {
    if (!GetPerformer()) {
        return true;
    }
    auto description = GetDescriptionAs<TDescription>(server, tx);
    if (!description) {
        return false;
    }
    auto optionalAttachments = server.GetDriveDatabase().GetCarAttachmentAssignments().GetAttachmentOfType(objectId, description->GetAttachmentType(), tx);

    if (!optionalAttachments) {
        return false;
    }

    if (description->GetAttachmentOrientation()) { // true - attachment, false - detachment
        if (optionalAttachments->empty()) {
            auto attachmentType = ToString(description->GetAttachmentType());
            tx.SetErrorInfo(
                "CarAttachmentActionTag::OnBeforeExit",
                TStringBuilder() << "cannot find attachment " << attachmentType,
                NDrive::MakeError("cannot_find_attachment_" + attachmentType)
            );
            return false;
        }
    } else {
        if (!optionalAttachments->empty()) {
            auto detachmentType = ToString(description->GetAttachmentType());
            tx.SetErrorInfo(
                "CarAttachmentActionTag::OnBeforeExit",
                TStringBuilder() << "attachment found " << detachmentType,
                NDrive::MakeError("attachmen_found_" + detachmentType)
            );
            return false;
        }
    }
    return true;
}

ITag::TFactory::TRegistrator<TCarAttachmentAssignmentTag> TCarAttachmentAssignmentTag::Registrator(TCarAttachmentAssignmentTag::Type());
TTagDescription::TFactory::TRegistrator<TCarAttachmentAssignmentTag::TDescription> TCarAttachmentAssignmentTag::TDescription::Registrator(TCarAttachmentAssignmentTag::Type());
