#pragma once

#include "device_tags.h"

#include <drive/backend/car_attachments/abstract/attachment.h>

class TCarAttachmentAssignmentTag: public TDeviceTagRecord {
private:
    using TBase = TDeviceTagRecord;

public:
    class TDescription: public TTagDescription {
    private:
        using TBase = TTagDescription;

    private:
        R_FIELD(EDocumentAttachmentType, AttachmentType, EDocumentAttachmentType::Unknown);
        R_FIELD(bool, AttachmentOrientation, true);

    public:
        NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

        NJson::TJsonValue DoSerializeMetaToJson() const override;
        bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;

    private:
        static TFactory::TRegistrator<TDescription> Registrator;
    };

public:
    static TString Type() {
        return "car_attachment_assignment_tag";
    }

public:
    using TBase::TBase;

    bool OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& tx, const TEvolutionContext* evolutionContext) const override;
    bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;

protected:
    bool OnBeforeExit(const TString& objectId, const NDrive::IServer& server, NDrive::TEntitySession& tx) const;

private:
    static TFactory::TRegistrator<TCarAttachmentAssignmentTag> Registrator;
};
