#pragma once


#include <drive/backend/compiled_riding/servicing.h>
#include <drive/backend/data/common/serializable.h>
#include <drive/backend/sessions/manager/common.h>

#include <rtline/util/types/field.h>

class TChargableTag;

class IServicingInfoHolder {
public:
    virtual ~IServicingInfoHolder() = default;

    virtual const TServicingInfo* GetServicingInfo() const = 0;
    virtual void SetServicingInfo(TServicingInfo&& value) = 0;
};

class TServicingTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    class TDescription: public TTagDescription {
    public:
        using TTagDescription::TTagDescription;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        R_FIELD(TVector<TString>, DeviceTags);
        R_FIELD(TVector<TString>, UserTags);
        R_FIELD(bool, Cancellable, true);

        DECLARE_FIELDS(
            Field(Cancellable, "cancellable"),
            Field(DeviceTags, "device_tags"),
            Field(UserTags, "user_tags")
        );
    };

public:
    R_FIELD(TString, SessionId);
    // ParentUserTagId represents parent user tag ID.
    R_FIELD(TString, ParentUserTagId);

    DECLARE_FIELDS(
        Field(SessionId, "session_id"),
        Field(ParentUserTagId, "parent_user_tag_id")
    );

public:
    using TBase::TBase;

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    bool IsEligible(const NDrive::IServer& server) const;
    bool IsEligible(const TDBTag& sessionTag) const;

    bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;
    bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) const override;

public:
    static bool Start(const TDBTag& self, const TUserPermissions& permissions, const NDrive::IServer& server, NDrive::TEntitySession& tx);

    static TString Type() {
        return "servicing_tag";
    }

private:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

    bool OnStarted(NDrive::TEntitySession& tx, TChargableTag& servicingTag, const TString& userId, const TCommonTagSessionManager::TSession& session, const NDrive::IServer& server) const;

private:
    static TFactory::TRegistrator<TServicingTag> Registrator;
};
