#include "state.h"

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/cars/car.h>
#include <drive/backend/roles/permissions.h>
#include <drive/backend/users/user.h>

#include <rtline/library/json/field.h>

NJson::TJsonValue TGenericUserStateTag::GetStateReport(ELocalization locale, const TConstDBTag& self, const TUserPermissions& permissions, const NDrive::IServer& server) const {
    NJson::TJsonValue result;
    result["name"] = GetName();
    result["tag_id"] = self.GetTagId();
    if (CarId) {
        auto car = server.GetDriveDatabase().GetCarManager().GetObject(CarId);
        if (car) {
            result["car"] = car->GetReport(locale, permissions.GetDeviceReportTraits());
        } else {
            result["car_id"] = CarId;
        }
    }
    if (UserId) {
        auto user = server.GetDriveDatabase().GetUsersData()->GetCachedObject(UserId);
        if (user) {
            result["user"] = user->GetReport();
        } else {
            result["user_id"] = UserId;
        }
    }
    if (SessionId) {
        result["session_id"] = SessionId;
    }
    return result;
}

bool TGenericUserStateTag::DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) {
    if (!TBase::DoSpecialDataFromJson(value, errors)) {
        return false;
    }
    return NJson::TryFieldsFromJson(value, GetFields(), errors);
}

void TGenericUserStateTag::SerializeSpecialDataToJson(NJson::TJsonValue& value) const {
    TBase::SerializeSpecialDataToJson(value);
    NJson::FieldsToJson(value, GetFields());
}

ITag::TFactory::TRegistrator<TGenericUserStateTag> TGenericUserStateTag::Registrator(TGenericUserStateTag::Type());
