#pragma once

#include <drive/backend/data/common/serializable.h>

#include <rtline/util/types/field.h>

namespace NDrive {
    class IUserState {
    public:
        virtual ~IUserState() = default;

        virtual NJson::TJsonValue GetStateReport(ELocalization locale, const TConstDBTag& self, const TUserPermissions& permissions, const NDrive::IServer& server) const = 0;
    };
}

class TGenericUserStateTag
    : public IJsonSerializableTag
    , public NDrive::IUserState
{
private:
    using TBase = IJsonSerializableTag;

public:
    R_FIELD(TString, CarId);
    R_FIELD(TString, UserId);
    R_FIELD(TString, SessionId);

    DECLARE_FIELDS(
        Field(CarId, "car_id"),
        Field(UserId, "user_id"),
        Field(SessionId, "session_id")
    );

public:
    static TString Type() {
        return "generic_user_state";
    }

public:
    using TBase::TBase;

    TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::User };
    }

    EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

    NJson::TJsonValue GetStateReport(ELocalization locale, const TConstDBTag& self, const TUserPermissions& permissions, const NDrive::IServer& server) const override;

private:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

private:
    static TFactory::TRegistrator<TGenericUserStateTag> Registrator;
};
