#pragma once

#include <drive/backend/data/common/serializable.h>

class TSwitchOfferTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    using TBase::TBase;

    static TString Type() {
        return "switch_offer_tag";
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Rewrite;
    }

    void SetTargetTagName(const TString& value) {
        TargetTagName = value;
    }

    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    virtual bool OnAfterAdd(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const override;
    virtual bool OnBeforeAdd(const TString& objectId, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) override;

protected:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

private:
    TString TargetTagName;

private:
    static TFactory::TRegistrator<TSwitchOfferTag> Registrator;
};
