#pragma once

#include <drive/backend/abstract/frontend.h>
#include <drive/backend/database/transaction/tx.h>
#include <drive/backend/tags/tag_description.h>

#include <rtline/util/types/field.h>

#include <util/generic/set.h>
#include <util/generic/string.h>

class TTagWithSubtags {
public:
    class TDescription: public TTagDescription {
    public:
        using TTagDescription::TTagDescription;

        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;

    protected:
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& value) override;

    private:
        R_FIELD(TVector<TString>, CarTags);
        R_FIELD(TVector<TString>, UserTags);

        DECLARE_FIELDS(
            Field(CarTags, "car_tags"),
            Field(UserTags, "user_tags")
        );
    };

protected:
    TSet<TString> CarTagIds;
    TSet<TString> UserTagIds;

    bool RemoveSubtags(const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
};
