#pragma once

#include <drive/backend/data/common/serializable.h>

class TTaxiValidationTag: public IJsonSerializableTag {
public:
    static constexpr TStringBuf Ok = "taxi_validation_ok";
    static constexpr TStringBuf CarOk = "taxi_validation_car_ok";
    static constexpr TStringBuf UserOk = "taxi_validation_user_ok";
    static constexpr TStringBuf CarFailure = "taxi_validation_car_failure";
    static constexpr TStringBuf UserFailure = "taxi_validation_user_failure";

private:
    using TBase = IJsonSerializableTag;

public:
    using TBase::TBase;

    static TString Type() {
        return "taxi_validation";
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::Car };
    }
    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    virtual bool OnAfterEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* evolutionContext) const override;
    virtual bool OnBeforeEvolve(const TDBTag& from, ITag::TPtr to, const TUserPermissions& permissions, const NDrive::IServer* server, NDrive::TEntitySession& session, const TEvolutionContext* evolutionContext) const override;

private:
    static TFactory::TRegistrator<TTaxiValidationTag> Registrator;
};

class TTaxiRouteHistoryPolicy: public NDrive::ITag::ICustomEvolutionPolicy {
public:
    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
};

class TTaxisharingPolicy: public NDrive::ITag::ICustomEvolutionPolicy {
public:
    TTaxisharingPolicy(ui32 fuelLevelThreshold)
        : FuelLevelThreshold(fuelLevelThreshold)
    {
    }

    virtual bool ExecuteAfterEvolveCommit(const TString& objectId, const NDrive::ITag* tag, const TUserPermissions& permissions, const NDrive::IServer* server) const override;
    virtual bool ExecuteBeforeEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;
    virtual bool ExecuteAfterEvolution(const TConstDBTag& fromTag, NDrive::ITag::TPtr toTag, const NDrive::IServer* server, const TUserPermissions& permissions, const NDrive::ITag::TEvolutionContext* eContext, NDrive::TEntitySession& session) const override;

private:
    ui32 FuelLevelThreshold;
};
