#pragma once

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/proto/tags.pb.h>

#include <drive/backend/user_insurance/entities.h>


class TUserKaskoTag: public ISerializableTag<NDrive::NProto::TUserKaskoTag> {
private:
    using TBase = ISerializableTag<TProto>;

public:
    class TDescription: public TTagDescription {
        using TDiscountMap = TMap<ui32, ui32>;
    private:
        R_FIELD(TString, KaskoPackageName);
        R_FIELD(TString, ScoreTagName, "user_scoring_insurance_tag");
        R_FIELD(TDiscountMap, DiscountMap);
        R_FIELD(NJson::TJsonValue, KaskoPackageParams);

    private:
        static TFactory::TRegistrator<TDescription> Registrator;
        using TBase = TTagDescription;

    public:
        using TBase::TBase;
        virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
        virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
        virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;

        ui32 GetDiscount(const ui32 percentile) const;
    };

    enum class EKaskoStatus {
        NoData          /* "no_data" */,
        Calculated      /* "calculated" */,
        Processing      /* "processing" */,
        NeedPso         /* "need_pso" */,
        Ordered         /* "ordered" */,
        Signed          /* "signed" */,
    };

public:
    static TFactory::TRegistrator<TUserKaskoTag> Registrator;

public:
    using TBase::TBase;

    static TString Type() {
        return "user_insurance_tag";
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::User };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::NoUnique;
    }

protected:
    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    bool DoSpecialDataFromJson(const NJson::TJsonValue& /*json*/, TMessagesCollector* /*errors*/) override;

private:
    R_OPTIONAL(NDrive::NRenins::TKaskoData, KaskoData);
};
