#pragma once

#include <drive/backend/data/common/serializable.h>

class TUserOriginTag: public IJsonSerializableTag {
private:
    using TBase = IJsonSerializableTag;

public:
    static TMaybe<TString> GetExternalUserId(const TString& userId, const NDrive::IServer& server, NDrive::TEntitySession& session);
    static TMaybe<TDBTag> Get(const TString& userId, const NDrive::IServer& server, NDrive::TEntitySession& session);
    static bool Set(const TString& userId, const TString& origin, const TString& externalUserId, const NDrive::IServer& server, NDrive::TEntitySession& session);

    static TString Type() {
        return "user_origin";
    }

public:
    using TBase::TBase;

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::User };
    }

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::Rewrite;
    }

protected:
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& value, TMessagesCollector* errors) override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& value) const override;

private:
    R_FIELD(TString, Origin);
    R_FIELD(TString, ExternalUserId);

private:
    static TFactory::TRegistrator<TUserOriginTag> Registrator;
};
