LIBRARY()

OWNER(g:drive-backend)

SRCS(
    notifications_abstract.cpp
    offer_container.cpp
    permission_tags.cpp
    service_session.cpp
    GLOBAL account_tags.cpp
    GLOBAL achievement.cpp
    GLOBAL additional_service.cpp
    GLOBAL additional_service_session.cpp
    GLOBAL area_tags.cpp
    GLOBAL billing_tags.cpp
    GLOBAL chargable.cpp
    GLOBAL coloring.cpp
    GLOBAL communication_channel_tags.cpp
    GLOBAL container_tag.cpp
    GLOBAL delegation.cpp
    GLOBAL delivery.cpp
    GLOBAL device_tags.cpp
    GLOBAL dedicated_fleet.cpp
    GLOBAL dedicated_fleet_session.cpp
    GLOBAL dictionary_tags.cpp
    GLOBAL event_tag.cpp
    GLOBAL events.cpp
    GLOBAL evolution_policy.cpp
    GLOBAL feedback.cpp
    GLOBAL fine.cpp
    GLOBAL fueling.cpp
    GLOBAL images.cpp
    GLOBAL long_term.cpp
    GLOBAL markers.cpp
    GLOBAL model.cpp
    GLOBAL notifications_tags.cpp
    GLOBAL offer.cpp
    GLOBAL operation_area.cpp
    GLOBAL parking_payment.cpp
    GLOBAL radar.cpp
    GLOBAL service_tags.cpp
    GLOBAL servicing.cpp
    GLOBAL sharing.cpp
    GLOBAL state.cpp
    GLOBAL support_tags.cpp
    GLOBAL switch.cpp
    GLOBAL tag_with_subtags.cpp
    GLOBAL taxi.cpp
    GLOBAL tech_dispatch.cpp
    GLOBAL telematics.cpp
    GLOBAL transformation.cpp
    GLOBAL user_insurance.cpp
    GLOBAL user_origin.cpp
    GLOBAL user_tags.cpp
)

GENERATE_ENUM_SERIALIZATION(area_tags.h)

GENERATE_ENUM_SERIALIZATION(billing_tags.h)

GENERATE_ENUM_SERIALIZATION(delegation.h)

GENERATE_ENUM_SERIALIZATION(device_tags.h)

GENERATE_ENUM_SERIALIZATION(fine.h)

GENERATE_ENUM_SERIALIZATION(markers.h)

GENERATE_ENUM_SERIALIZATION(radar.h)

GENERATE_ENUM_SERIALIZATION(sharing.h)

GENERATE_ENUM_SERIALIZATION(support_tags.h)

GENERATE_ENUM_SERIALIZATION(tech_dispatch.h)

GENERATE_ENUM_SERIALIZATION(telematics.h)

GENERATE_ENUM_SERIALIZATION(user_tags.h)

GENERATE_ENUM_SERIALIZATION(dedicated_fleet.h)

GENERATE_ENUM_SERIALIZATION(account_tags.h)

PEERDIR(
    drive/backend/abstract
    drive/backend/actions
    drive/backend/alerts/types
    drive/backend/areas
    drive/backend/billing
    drive/backend/chat
    drive/backend/chat_robots/configuration
    drive/backend/common
    drive/backend/compiled_riding
    drive/backend/data/common
    drive/backend/data/proto
    drive/backend/database/drive
    drive/backend/database/history
    drive/backend/database/transaction
    drive/backend/device_snapshot
    drive/backend/fueling_manager
    drive/backend/head
    drive/backend/processor
    drive/backend/proto
    drive/backend/radar
    drive/backend/rt_background/manager
    drive/backend/support_center/categorizer
    drive/backend/support_center/feedback
    drive/backend/support_center/yandex
    drive/backend/tags
    drive/backend/user_devices
    drive/backend/user_insurance
    drive/library/cpp/catboost
    drive/library/cpp/covid_pass
    drive/library/cpp/datasync
    drive/library/cpp/deeplink
    drive/library/cpp/octopus
    drive/library/cpp/openssl
    drive/library/cpp/parking/api
    drive/library/cpp/scheme
    drive/library/cpp/taxi/promocodes
    drive/library/cpp/taxi/routehistory
    drive/library/cpp/taxi/signalq_drivematics_api
    drive/library/cpp/tracks
    drive/library/cpp/threading
    drive/telematics/api/sensor
    drive/telematics/api/server
    drive/telematics/common
    drive/telematics/protocol
    drive/telematics/server/location
    drive/telematics/server/tasks
    library/cpp/protobuf/json
    library/cpp/string_utils/relaxed_escaper
    rtline/library/geometry
    rtline/library/graph/geometry_graph/common
    rtline/library/geometry
    rtline/library/json
    rtline/library/json/proto
    rtline/util/algorithm
)

END()
