#pragma once

#include "drive_api.h"

#include <drive/backend/cars/hardware.h>

class TCarAttachmentReportContext : public ICarAttachmentReportContext {
public:
    TCarAttachmentReportContext(const TDriveAPI* driveApi)
        : DriveApi(driveApi)
        , RegistryDocumentTraits(NAttachmentReport::NoStructureTraits)
    {}

    virtual TString GetMdsLink(const TString& bucketName, const TString& path) const override;

    TCarAttachmentReportContext& SetRegistryDocumentTraits(NAttachmentReport::TStructureReportTraits traits) {
        RegistryDocumentTraits = traits;
        return *this;
    }

    NAttachmentReport::TStructureReportTraits GetRegistryDocumentTraits() const override {
        return RegistryDocumentTraits;
    }

private:
    const TDriveAPI* DriveApi;
    NAttachmentReport::TStructureReportTraits RegistryDocumentTraits;
};
