#pragma once

#include <drive/backend/database/history/db_entities.h>

#include <drive/backend/roles/config.h>
#include <drive/backend/tags/abstract.h>
#include <drive/backend/tags/config.h>

#include <drive/library/cpp/geocoder/api/client.h>

class TBillingConfig;
class TCarsDBConfig;
class TDatasyncClientConfig;
class TDocumentPhotosConfig;
class TMajorClientConfig;
class TOctopusClientConfig;
class TPassportClientConfig;
class TRTLineAPIConfig;
class TS3ClientConfig;
class TSamsaraClientConfig;
class TSolomonClientConfig;
class TStaffClientConfig;
class TStartrekClientConfig;
class TTakeoutClientConfig;
class TUsersDBConfig;
class TYandexDiskClientConfig;

namespace NDrive::NAutocode {
    class TAutocodeClientConfig;
}

namespace NDrive {
    class TFinesApiConfig;
}

namespace NDrive::NFine {
    class TFinesManagerConfig;
}

namespace NDrive {
    class TIncidentsManagerConfig;
}

namespace NDrive::NRenins {
    class TReninsClaimClientConfig;
}

namespace NDrive {
    class TIngosClientConfig;
    class TReninsClientConfig;
    using TSearchEntities = ui32;
    class TSupportAIApiConfig;
}

namespace NDrivematics {
    class TZoneConfig;
}

class TDriveAPIConfig: public TTagsManagerConfig {
private:
    R_FIELD(TDuration, GeoAreasFreshness, TDuration::Minutes(2));
    R_FIELD(TString, OffersStorageName);
    R_READONLY(TDuration, OfferLivetime, TDuration::Minutes(5));

    R_READONLY(TPropositionsManagerConfig, ActionPropositionsConfig);
    R_READONLY(THistoryConfig, RolesHistoryConfig);

    R_READONLY(THistoryConfig, HeadAppHistoryConfig);

    R_READONLY(THistoryConfig, StateFiltersConfig);
    R_READONLY(TDBEntitiesManagerWithPropositionsConfig, AreasConfig);

    static inline TDBEntitiesManagerWithPropositionsConfig LandingsConfigDefault() {
        return { THistoryConfig().SetDeep(TDuration::Days(180)), {} };
    };
    R_READONLY(TDBEntitiesManagerWithPropositionsConfig, LandingsConfig, LandingsConfigDefault());

    R_FIELD(NDrive::TSearchEntities, SearchEntities, 0);
    R_READONLY(TString, PrivateDataClientType, "datasync");
    R_READONLY(TString, TakeoutClientType, "fake");
    R_READONLY(TString, OctopusClientType, "fake");

    R_READONLY(bool, NeedAttachmentManager, true);
    R_READONLY(bool, NeedDatasyncQueueClient, false);

    THolder<TBillingConfig> BillingConfig;
    THolder<TS3ClientConfig> MDSClientConfig;
    THolder<NDrive::NAutocode::TAutocodeClientConfig> AutocodeClientConfig;
    THolder<TMajorClientConfig> MajorClientConfig;
    THolder<NDrive::TFinesApiConfig> ElementFinesClientConfig;
    THolder<TYandexDiskClientConfig> YandexDiskClientConfig;
    THolder<TStartrekClientConfig> StartrekClientConfig;
    THolder<TSolomonClientConfig> SolomonClientConfig;
    THolder<TSolomonClientConfig> DeprecatedSolomonClientConfig;
    THolder<TSamsaraClientConfig> SamsaraClientConfig;
    THolder<TStaffClientConfig> StaffClientConfig;
    THolder<NDrive::NFine::TFinesManagerConfig> FinesManagerConfig;
    THolder<NDrive::NRenins::TReninsClaimClientConfig> ReninsClaimConfig;
    THolder<NDrive::TIncidentsManagerConfig> IncidentsManagerConfig;
    THolder<NDrive::TReninsClientConfig> ReninsConfig;
    THolder<NDrive::TIngosClientConfig> IngosConfig;
    THolder<TDatasyncClientConfig> DatasyncConfig;
    THolder<TDocumentPhotosConfig> DocumentPhotosConfig;
    THolder<TTakeoutClientConfig> TakeoutConfig;
    THolder<TOctopusClientConfig> OctopusConfig;
    THolder<TUsersDBConfig> UsersConfig;
    THolder<TCarsDBConfig> CarsConfig;
    THolder<TPassportClientConfig> PassportClientConfig;
    THolder<NDrive::TGeocoder::TOptions> GeocoderOptions;
    THolder<NDrivematics::TZoneConfig> ZoneConfig;

    R_READONLY(TString, DBName);
    R_READONLY(TRolesConfig, RolesFeaturesConfig);
    R_READONLY(TDuration, HeadAppFreshness, TDuration::Seconds(10));

public:
    TDriveAPIConfig();
    ~TDriveAPIConfig();

    const TBillingConfig* GetBillingConfig() const {
        return BillingConfig.Get();
    }

    const TS3ClientConfig* GetMDSClientConfig() const {
        return MDSClientConfig.Get();
    }

    const NDrive::NAutocode::TAutocodeClientConfig* GetAutocodeClientConfig() const {
        return AutocodeClientConfig.Get();
    }

    const TMajorClientConfig* GetMajorClientConfig() const {
        return MajorClientConfig.Get();
    }

    const NDrive::TFinesApiConfig* GetElementFinesClientConfig() const {
        return ElementFinesClientConfig.Get();
    }

    const TYandexDiskClientConfig* GetYandexDiskClientConfig() const {
        return YandexDiskClientConfig.Get();
    }

    const TStartrekClientConfig* GetStartrekClientConfig() const {
        return StartrekClientConfig.Get();
    }

    const TSolomonClientConfig* GetSolomonClientConfig() const {
        return SolomonClientConfig.Get();
    }

    const TSolomonClientConfig* GetDeprecatedSolomonClientConfig() const {
        return DeprecatedSolomonClientConfig.Get();
    }

    const TSamsaraClientConfig* GetSamsaraClientConfig() const {
        return SamsaraClientConfig.Get();
    }

    const TStaffClientConfig* GetStaffClientConfig() const {
        return StaffClientConfig.Get();
    }

    const NDrive::NFine::TFinesManagerConfig* GetFinesManagerConfig() const {
        return FinesManagerConfig.Get();
    }

    const NDrive::NRenins::TReninsClaimClientConfig* GetReninsClaimConfig() const {
        return ReninsClaimConfig.Get();
    }

    const NDrive::TIncidentsManagerConfig* GetIncidentsManagerConfig() const {
        return IncidentsManagerConfig.Get();
    }

    const NDrive::TReninsClientConfig* GetReninsConfig() const {
        return ReninsConfig.Get();
    }

    const NDrive::TIngosClientConfig* GetIngosConfig() const {
        return IngosConfig.Get();
    }

    const TPassportClientConfig* GetPassportClientConfig() const {
        return PassportClientConfig.Get();
    }

    const TDatasyncClientConfig* GetDatasyncConfig() const {
        return DatasyncConfig.Get();
    }

    const TDocumentPhotosConfig* GetDocumentPhotosConfig() const {
        return DocumentPhotosConfig.Get();
    }

    const TTakeoutClientConfig* GetTakeoutConfig() const {
        return TakeoutConfig.Get();
    }

    const TOctopusClientConfig* GetOctopusConfig() const {
        return OctopusConfig.Get();
    }

    const TUsersDBConfig* GetUsersConfig() const {
        return UsersConfig.Get();
    }

    const TCarsDBConfig* GetCarsConfig() const {
        return CarsConfig.Get();
    }

    const NDrive::TGeocoder::TOptions* GetGeocoderOptions() const {
        return GeocoderOptions.Get();
    }

    const NDrivematics::TZoneConfig* GetZoneConfig() const {
        return ZoneConfig.Get();
    }

    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;
};
