#include "takeout.h"

bool TTakeoutRequest::Parse(const NStorage::TTableRecord& record) {
    Id = record.Get("id");
    JobId = record.Get("job_id");
    UserId = record.Get("user_id");

    if (!GetTimestampFromTableRecord(record, "enqueued_at", EnqueuedAt)) {
        return false;
    }
    GetTimestampFromTableRecord(record, "processing_started_at", ProcessingStartedAt);
    GetTimestampFromTableRecord(record, "processing_completed_at", ProcessingCompletedAt);

    return true;
}

NStorage::TTableRecord TTakeoutRequest::SerializeToTableRecord() const {
    NStorage::TTableRecord result;

    if (!Id)  {
        result.Set("id", "uuid_generate_v4()");
    } else {
        result.Set("id", Id);
    }

    result.Set("job_id", JobId);
    result.Set("user_id", UserId);
    result.Set("enqueued_at", EnqueuedAt.Seconds());

    if (ProcessingStartedAt != TInstant::Zero()) {
        result.Set("processing_started_at", ProcessingStartedAt.Seconds());
    }

    if (ProcessingCompletedAt != TInstant::Zero()) {
        result.Set("processing_completed_at", ProcessingCompletedAt.Seconds());
    }

    return result;
}

bool TTakeoutRequest::GetTimestampFromTableRecord(const NStorage::TTableRecord& record, const TString& fieldName, TInstant& result) {
    TString stringRepr = record.Get(fieldName);
    ui64 intRepr;
    if (!stringRepr || !TryFromString(stringRepr, intRepr)) {
        return false;
    }
    result = TInstant::Seconds(intRepr);
    return true;
}

TVector<TTakeoutRequest> TTakeoutRequestDB::GetNewTakeoutRequests(ui32 limit) const {
    auto fetchResult = FetchWithCustomQuery("SELECT * FROM " + GetTableName() + " WHERE processing_completed_at IS NULL LIMIT " + ToString(limit)).GetResult();
    TVector<TTakeoutRequest> result;
    for (auto&& it : fetchResult) {
        result.push_back(std::move(it.second));
    }
    return result;
}
