#pragma once

#include <drive/backend/database/entity/manager.h>

class TTakeoutRequest {
    R_READONLY(TString, Id);
    R_READONLY(TString, JobId);
    R_READONLY(TString, UserId);
    R_READONLY(TInstant, EnqueuedAt);
    R_FIELD(TInstant, ProcessingStartedAt);
    R_FIELD(TInstant, ProcessingCompletedAt);

public:
    TTakeoutRequest() = default;

    TTakeoutRequest(const TTakeoutRequest& other) = default;

    TTakeoutRequest(const TString& jobId, const TString& userId)
        : JobId(jobId)
        , UserId(userId)
        , EnqueuedAt(Now())
    {
    }

    bool Parse(const NStorage::TTableRecord& record);

    NStorage::TTableRecord SerializeToTableRecord() const;

private:
    bool GetTimestampFromTableRecord(const NStorage::TTableRecord& record, const TString& fieldName, TInstant& result);
};

class TTakeoutRequestDB: public TDBEntities<TTakeoutRequest> {
private:
    using TBase = TDBEntities<TTakeoutRequest>;

public:
    using TBase::TBase;

    virtual TString GetTableName() const override {
        return "takeout_requests";
    }

    virtual TString GetMainId(const TTakeoutRequest& e) const override {
        return e.GetId();
    }

    TVector<TTakeoutRequest> GetNewTakeoutRequests(ui32 limit = 20) const;
};
