#pragma once

#include <util/generic/string.h>
#include <util/string/builder.h>
#include <util/string/printf.h>

class TCarsharingUrl {
private:
    TString BaseUrl;

public:
    TCarsharingUrl();

    TString ClientPage(const TString& userId, const TString& page) {
        return Sprintf("%s/#/clients/%s/%s", BaseUrl.data(), userId.data(), page.data());
    }

    TString ClientInfo(const TString& userId) {
        return ClientPage(userId, "info");
    }

    TString ClientOrders(const TString& userId) {
        return ClientPage(userId, "ride");
    }

    TString ClientSessions(const TString& userId) {
        return ClientPage(userId, "sessions");
    }

    TString CarPage(const TString& carId, const TString& page) {
        auto result = TStringBuilder() << BaseUrl << "/#/cars/" << carId;
        if (page) {
            result << "/" << page;
        }
        return result;
    }

    TString CarInfo(const TString& carId) {
        return CarPage(carId, TString{});
    }

    TString SessionPage(const TString& sessionId) const {
        return Sprintf("%s/#/session/%s", BaseUrl.data(), sessionId.data());
    }

    TString TrackPage(const TString& sessionId) const {
        return Sprintf("%s/#/tracks?session_id=%s", BaseUrl.data(), sessionId.data());
    }

    TString ChatPage(const TString& userId, const TString& chatId) const {
        return Sprintf("%s/#/chats?user_id=%s&chat_id=%s", BaseUrl.data(), userId.data(), chatId.data());
    }

    TString ActionPage(const TString& actionId) const {
        return Sprintf("%s/#/#/settings/actions/%s", BaseUrl.data(), actionId.data());
    }

    TString RolePage(const TString& actionId) const {
        return Sprintf("%s/#/#/settings/roles?role_id=%s", BaseUrl.data(), actionId.data());
    }
};
