#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/generic/serialized_enum.h>

THistoryConfig& THistoryConfig::SetDeep(const TDuration d) {
    Deep = d;
    MaxHistoryDeep = Max(MaxHistoryDeep, d);
    return *this;
}

void THistoryConfig::Init(const TYandexConfig::Section* section) {
    const auto& directives = section->GetDirectives();
    PingPeriod = directives.Value("PingPeriod", PingPeriod);
    GuaranteeFinishedTransactionsDuration = directives.Value("GuaranteeFinishedTransactionsDuration", GuaranteeFinishedTransactionsDuration);
    MaxHistoryDeep = directives.Value("MaxHistoryDeep", MaxHistoryDeep);
    SetDeep(directives.Value("Deep", Deep));
    UseCache = directives.Value("UseCache", UseCache);
    MaximalLockedIntervalDuration = directives.Value("MaximalLockedIntervalDuration", MaximalLockedIntervalDuration);
    ChunkSize = directives.Value("ChunkSize", ChunkSize);
    AssertCorrectConfig(MaximalLockedIntervalDuration > GuaranteeFinishedTransactionsDuration, "MaximalLockedIntervalDuration > GuaranteeFinishedTransactionsDuration");
}

void THistoryConfig::ToString(IOutputStream& os) const {
    os << "PingPeriod: " << PingPeriod << Endl;
    os << "Deep: " << Deep << Endl;
    os << "GuaranteeFinishedTransactionsDuration: " << GuaranteeFinishedTransactionsDuration << Endl;
    os << "MaxHistoryDeep: " << MaxHistoryDeep << Endl;
    os << "UseCache: " << UseCache << Endl;
    os << "MaximalLockedIntervalDuration: " << MaximalLockedIntervalDuration << Endl;
    os << "ChunkSize: " << ChunkSize << Endl;
}
