#pragma once

#include <library/cpp/yconf/conf.h>

#include <rtline/library/storage/structured.h>
#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>

class THistoryConfig {
private:
    R_READONLY(TDuration, Deep, TDuration::Days(30));
    R_FIELD(TDuration, GuaranteeFinishedTransactionsDuration, TDuration::Minutes(2));
    R_FIELD(TDuration, PingPeriod, TDuration::Seconds(1));
    R_FIELD(TDuration, MaxHistoryDeep, TDuration::Days(30));
    R_FIELD(bool, UseCache, true);
    R_FIELD(TDuration, MaximalLockedIntervalDuration, TDuration::Minutes(10));
    R_FIELD(size_t, ChunkSize, 1000000);

public:
    THistoryConfig& SetDeep(const TDuration d);

    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
