#include "db_entities.h"

void TDBEntitiesManagerConfig::Init(const TYandexConfig::Section* section) {
    DBName = section->GetDirectives().Value("DBName", DBName);
    auto children = section->GetAllChildren();
    auto it = children.find("History");
    if (it != children.end()) {
        HistoryConfig.Init(it->second);
    }
}

void TDBEntitiesManagerConfig::ToString(IOutputStream& os) const {
    if (!!DBName) {
        os << "DBName: " << DBName << Endl;
    }
    os << "<History>" << Endl;
    HistoryConfig.ToString(os);
    os << "</History>" << Endl;
}

void TDBEntitiesManagerWithPropositionsConfig::Init(const TYandexConfig::Section* section) {
    TBase::Init(section);
    auto children = section->GetAllChildren();
    auto it = children.find("Propositions");
    if (it != children.end()) {
        PropositionsConfig.Init(it->second);
    }
}

void TDBEntitiesManagerWithPropositionsConfig::ToString(IOutputStream& os) const {
    TBase::ToString(os);
    os << "<Propositions>" << Endl;
    PropositionsConfig.ToString(os);
    os << "</Propositions>" << Endl;
}
