#include "propositions.h"

NJson::TJsonValue TConfirmationInfo::GetReport() const {
    NJson::TJsonValue result;
    result.InsertValue("user_id", UserId);
    result.InsertValue("history_instant", HistoryInstant.Seconds());
    result.InsertValue("comment", Comment);
    return result;
}

void TPropositionsManagerConfig::Init(const TYandexConfig::Section* section) {
    DefaultSelfConfirmationPolicy = section->GetDirectives().Value("DefaultSelfConfirmationPolicy", DefaultSelfConfirmationPolicy);
    DefaultDoubleConfirmationPolicy = section->GetDirectives().Value("DefaultDoubleConfirmationPolicy", DefaultDoubleConfirmationPolicy);
    DefaultConfirmationsNeed = section->GetDirectives().Value("DefaultConfirmationsNeed", DefaultConfirmationsNeed);
    DefaultPropositionLivetime = section->GetDirectives().Value("DefaultPropositionLivetime", DefaultPropositionLivetime);
}

void TPropositionsManagerConfig::ToString(IOutputStream& os) const {
    os << "DefaultSelfConfirmationPolicy: " << DefaultSelfConfirmationPolicy << Endl;
    os << "DefaultDoubleConfirmationPolicy: " << DefaultDoubleConfirmationPolicy << Endl;
    os << "DefaultConfirmationsNeed: " << DefaultConfirmationsNeed << Endl;
    os << "DefaultPropositionLivetime: " << DefaultPropositionLivetime << Endl;
}
