#include "session_builder.h"

bool CompareSessionsByActiveness(const ISession& left, const ISession& right) {
    auto leftActive = left.GetCurrentState() == ISession::ECurrentState::Started ? 1 : 0;
    auto leftLastEventId = left.GetLastEventId();
    auto rightActive = right.GetCurrentState() == ISession::ECurrentState::Started ? 1 : 0;
    auto rightLastEventId = right.GetLastEventId();
    return std::make_tuple(leftActive, leftLastEventId) < std::make_tuple(rightActive, rightLastEventId);
}
