#pragma once

#include <util/generic/string.h>
#include <util/system/compiler.h>
#include <util/system/src_location.h>

enum class EDriveSessionResult;

namespace NDrive {
    class TInfoEntitySession;
    struct TError;

    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error, TMaybe<EDriveSessionResult> result, TInfoEntitySession& session);
    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error, TMaybe<EDriveSessionResult> result);
    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error, TError&& err, TInfoEntitySession& session);
    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error, TError&& err);
    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error, TInfoEntitySession& session);
    void Throw(TSourceLocation location, TStringBuf function, TStringBuf condition, TMaybe<int> code, TStringBuf error);
}

#define R_ENSURE(CONDITION, CODE, ...)           \
    do {                                         \
        if (Y_UNLIKELY(!(CONDITION))) {          \
            NDrive::Throw(__LOCATION__, TStringBuf(Y_FUNC_SIGNATURE), TStringBuf(#CONDITION), CODE, TStringBuilder() << __VA_ARGS__);\
        }                                        \
    } while (false)
