#include <drive/backend/database/transaction/tx.h>

#include <rtline/library/storage/sqlite/structured.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(DriveTx) {
    Y_UNIT_TEST(Simple) {
        auto name = "sqlite_dump";
        auto path = BinaryPath("drive/tests/resources/extmaps-carsharing-testing/extmaps-carsharing-testing.sqlite");
        auto database = MakeAtomicShared<NSQLite::TDatabase>(name, path);

        TDatabaseSessionConstructor dsc(database);
        {
            auto tx = dsc.BuildTx<NSQL::Writable>();
            UNIT_ASSERT(tx);
            UNIT_ASSERT(tx->IsWritable());
        }
        {
            auto tx = dsc.BuildTx<NSQL::ReadOnly>();
            UNIT_ASSERT(tx);
            UNIT_ASSERT(!tx->IsWritable());
        }
    }

    Y_UNIT_TEST(Deferred) {
        auto name = "sqlite_dump";
        auto path = BinaryPath("drive/tests/resources/extmaps-carsharing-testing/extmaps-carsharing-testing.sqlite");
        auto database = MakeAtomicShared<NSQLite::TDatabase>(name, path);

        TDatabaseSessionConstructor dsc(database);
        {
            auto tx = NDrive::TEntitySession();
            UNIT_ASSERT(!tx);
        }
        {
            auto tx = dsc.BuildTx<NSQL::Writable | NSQL::Deferred>();
            UNIT_ASSERT(tx);
            UNIT_ASSERT(!tx.HasTransaction());
            UNIT_ASSERT(tx->IsWritable());
            UNIT_ASSERT(tx.HasTransaction());
        }
    }
}
