#pragma once

#include <drive/telematics/protocol/sensor.h>
#include <drive/telematics/protocol/vega.h>
#include <drive/telematics/server/location/heartbeat.h>
#include <drive/telematics/server/location/names.h>

#include <library/cpp/yconf/conf.h>

#include <util/datetime/base.h>
#include <util/generic/map.h>

namespace NDevicesSnapshotManager {
    struct TFetchOptions {
        TDuration UpdatePeriod;
        bool EnableSecondStage;

        inline TFetchOptions(TDuration updatePeriod = TDuration::Seconds(60), bool enableSecondStage = true)
            : UpdatePeriod(updatePeriod)
            , EnableSecondStage(enableSecondStage)
        {
        }
        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& os) const;
    };
    using THeartbeatsOptions = TFetchOptions;
    using TLocationOptions = TFetchOptions;
    using TSensorOptions = TFetchOptions;

    struct TOptions {
        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& os) const;

        TMap<TString, THeartbeatsOptions> HeartbeatOptions = {
            {NDrive::DefaultHeartbeatName, {TDuration::Seconds(1), false}},
            {NDrive::ConfiguratorHeartbeatName, {TDuration::Seconds(30), false}},
        };
        TMap<TString, TLocationOptions> LocationOptions = {
            {NDrive::RawLocationName, {TDuration::Seconds(1), true}},
            {NDrive::LinkedLocationName, {TDuration::Seconds(1), true}},
            {NDrive::BeaconsLocationName, {TDuration::Seconds(1), true}},
        };
        TMap<NDrive::TSensorId, TSensorOptions> SensorOptions = {
            {CAN_ENGINE_IS_ON, {TDuration::Seconds(5), true}},
            {CAN_ODOMETER_KM, {TDuration::Seconds(1), true}},
            {{CAN_FUEL_LEVEL_P, CAN_ENGINE_IS_ON}, {TDuration::Seconds(10), true}},
            {CAN_CUSTOM_FUEL_VOLUME, {TDuration::Seconds(10), true}},
            {CAN_SPEED, {TDuration::Seconds(10), true}},
            {VEGA_SPEED, {TDuration::Seconds(1), true}},
        };
        TDuration FutureFilter = TDuration::Minutes(1);
        TDuration SensorTimeout = TDuration::Seconds(2);
        TDuration UpdatePeriod = TDuration::Seconds(1);
        TDuration HashUpdatePeriod = TDuration::Seconds(10);
        bool EnableFirstStageFetching = true;
        bool EnableSecondStageFetching = true;
    };
    const TVector<TString> AllLocations = {
        NDrive::RawLocationName,
        NDrive::LBSLocationName,
        NDrive::LinkedLocationName,
        NDrive::HeadLocationName,
        NDrive::BeaconsLocationName,
        NDrive::GeocodedLocationName,
    };
    const TVector<NDrive::TSensorId> AllSensors = {
        CAN_ENGINE_IS_ON,
        CAN_ODOMETER_KM,
        {CAN_FUEL_LEVEL_P, CAN_ENGINE_IS_ON},
        CAN_CUSTOM_FUEL_VOLUME,
        CAN_FUEL_DISTANCE_KM,
        CAN_DRIVER_DOOR,
        CAN_PASS_DOOR,
        CAN_L_REAR_DOOR,
        CAN_R_REAR_DOOR,
        CAN_HOOD,
        CAN_TRUNK,
        CAN_SPEED,
        VEGA_ACC_VOLTAGE,
        NDrive::NVega::AuxFuelLevel<1>(),
        NDrive::NVega::AuxFuelLevel<2>(),
        VEGA_POWER_VOLTAGE,
        VEGA_SPEED,
        {VEGA_SPEED, CAN_ENGINE_IS_ON},
        VEGA_NRF_VISIBLE_MARKS_BF,
        VEGA_NRF_BATTLOW_MARKS_BF,
        VEGA_NRF_MARK_ID_1,
        NDrive::NVega::DigitalOutput<3>(),
        NDrive::NVega::BlePasskey,
        NDrive::NVega::BleSessionKey,
        NDrive::NVega::SvrRawState,
        BLE_EXT_BOARD_MAC,
        VEGA_GSM_SIGNAL_LEVEL,
        VEGA_GPS_INVIEW,
        VEGA_SAT_USED,
        VEGA_GPS_MOVE_SENSOR,
        CAN_ENGINE_TEMP,
        CAN_HAND_BREAK,
        BLE_FUEL_LEVEL,
        CAN_ACCELERATOR,
    };
};
