#include "config.h"

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/yconf/conf.h>

#include <util/string/builder.h>

Y_UNIT_TEST_SUITE(DeviceSnapshotManagerConfig) {
    Y_UNIT_TEST(Parse) {
        TStringBuilder conf;
        conf << "<HeartbeatOptions>" << Endl;
        conf << "<" << "default" << ">" << Endl;
        conf << "UpdatePeriod: 1s" << Endl;
        conf << "EnableSecondStage: false" << Endl;
        conf << "</" << "default" << ">" << Endl;
        conf << "</HeartbeatOptions>" << Endl;

        conf << "<LocationOptions>" << Endl;
        conf << "<raw>" << Endl;
        conf << "UpdatePeriod: 2s" << Endl;
        conf << "EnableSecondStage: true" << Endl;
        conf << "</raw>" << Endl;
        conf << "</LocationOptions>" << Endl;

        conf << "<SensorOptions>" << Endl;
        conf << "<" << "tamper_1-100" << ">" << Endl;
        conf << "UpdatePeriod: 3s" << Endl;
        conf << "EnableSecondStage: true" << Endl;
        conf << "</" << "tamper_1-100" << ">" << Endl;

        conf << "<speed>" << Endl;
        conf << "UpdatePeriod: 4s" << Endl;
        conf << "EnableSecondStage: true" << Endl;
        conf << "</speed>" << Endl;

        conf << "</SensorOptions>" << Endl;
        conf << "SensorTimeout: 100s" << Endl;
        TAnyYandexConfig yConf;
        UNIT_ASSERT(yConf.ParseMemory(conf));
        NDevicesSnapshotManager::TOptions options;
        options.Init(*yConf.GetRootSection());

        UNIT_ASSERT_VALUES_EQUAL(options.HeartbeatOptions.size(), 1);
        {
            auto fetchOptions = options.HeartbeatOptions[NDrive::DefaultHeartbeatName];
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.UpdatePeriod, TDuration::Seconds(1));
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.EnableSecondStage, false);
        }
        UNIT_ASSERT_VALUES_EQUAL(options.LocationOptions.size(), 1);
        {
            auto fetchOptions = options.LocationOptions[NDrive::RawLocationName];
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.UpdatePeriod, TDuration::Seconds(2));
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.EnableSecondStage, true);
        }
        UNIT_ASSERT_VALUES_EQUAL(options.SensorOptions.size(), 2);
        {
            auto fetchOptions = options.SensorOptions[NDrive::TSensorId{VEGA_TAMPER_1, 100}];
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.UpdatePeriod, TDuration::Seconds(3));
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.EnableSecondStage, true);
        }
        {
            auto fetchOptions = options.SensorOptions[VEGA_SPEED];
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.UpdatePeriod, TDuration::Seconds(4));
            UNIT_ASSERT_VALUES_EQUAL(fetchOptions.EnableSecondStage, true);
        }
        UNIT_ASSERT_VALUES_EQUAL(options.SensorTimeout, TDuration::Seconds(100));
    }
}
