#include "snapshot.h"

#include <drive/backend/cars/car.h>

TMaybe<NDrive::TSensor> NDrive::GetFuelLevel(
    TMaybe<TSensor> fuelLevel,
    TMaybe<TSensor> fuelVolume,
    const TDriveCarInfo* carInfo,
    const TDriveModelData* modelInfo
) {
    if (!fuelVolume) {
        return fuelLevel;
    }
    auto timeout = NDrive::GetServer().GetSettings().GetValue<TDuration>("telematics.sensor_fetcher.fuel_level_percent_timeout").GetOrElse(TDuration::Minutes(10));
    if (fuelLevel && fuelVolume->Timestamp - fuelLevel->Timestamp < timeout) {
        return fuelLevel;
    }

    auto fuelVolumeValue = fuelVolume->TryConvertTo<double>();
    if (!fuelVolumeValue) {
        return {};
    }

    double tankVolume = NDrive::GetFuelTankVolume(carInfo, modelInfo);
    Y_ENSURE(tankVolume > 0.001);

    auto result = fuelVolume;
    result->Value = *fuelVolumeValue * 100.0 / tankVolume;
    return result;
}
