#pragma once

#include <library/cpp/json/json_value.h>
#include <library/cpp/object_factory/object_factory.h>

class TBlob;

namespace NDrive {
    class IObjectSnapshot {
    protected:
        virtual TBlob DoSerializeToBlob() const = 0;
        virtual bool DoDeserializeFromBlob(const TBlob& data) = 0;
        virtual NJson::TJsonValue DoSerializeToJson() const = 0;
        virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonValue) = 0;

    public:
        virtual ~IObjectSnapshot() = default;

    public:
        using TPtr = TAtomicSharedPtr<IObjectSnapshot>;
        using TFactory = NObjectFactory::TParametrizedObjectFactory<IObjectSnapshot, TString>;

    public:
        TBlob SerializeToBlob() const;
        NJson::TJsonValue SerializeToJson() const;

        bool DeserializeFromJson(const NJson::TJsonValue& jsonValue);

        virtual TString GetTypeName() const = 0;

    public:
        static IObjectSnapshot::TPtr ConstructFromBlob(const TBlob& data);
        static IObjectSnapshot::TPtr ConstructFromJson(const NJson::TJsonValue& jsonValue);
        static IObjectSnapshot::TPtr ConstructFromJsonString(const TString& jsonStr);
    };
}
