#pragma once

#include "abstract.h"

#include <library/cpp/json/json_reader.h>

#include <rtline/util/types/accessor.h>

#include <util/memory/blob.h>

class TImagesSnapshot: public NDrive::IObjectSnapshot {
public:
    struct TImage {
        TString ExternalId;
        TString Path;
        TString PreviewPath;
        TString Marker;
        TString MD5;
        TString Origin;
        TMaybe<ui64> ImageId;
    };
    using TImages = TVector<TImage>;

private:
    static TFactory::TRegistrator<TImagesSnapshot> Registrator;
    virtual TBlob DoSerializeToBlob() const override;
    virtual bool DoDeserializeFromBlob(const TBlob& data) override;

private:
    NJson::TJsonValue DoSerializeToJson() const override;
    bool DoDeserializeFromJson(const NJson::TJsonValue& jsonValue) override;

public:
    TImagesSnapshot() = default;

    TString GetTypeName() const override {
        return "images_snapshot";
    }

    ui64 CalcHash() const;

    void AddImage(TImage&& image);

private:
    R_OPTIONAL(TString, Comment);
    R_READONLY(TImages, Images);
};
