#include "tag.h"

#include <drive/backend/proto/snapshot.pb.h>

#include <rtline/library/json/parse.h>

template <>
NJson::TJsonValue NJson::ToJson(const TTagSnapshot::EActionReason& object) {
    return NJson::ToJson(NJson::Stringify(object));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, TTagSnapshot::EActionReason& result) {
    return NJson::TryFromJson(value, NJson::Stringify(result));
}

NDrive::IObjectSnapshot::TFactory::TRegistrator<TTagSnapshot> TTagSnapshot::Registrator("tag_snapshot");

void TTagSnapshot::AddHistoryActionReason(const EActionReason reason) {
    HistoryActionReasons.emplace(reason);
}

TString TTagSnapshot::GetTypeName() const {
    return "tag_snapshot";
}

TBlob TTagSnapshot::DoSerializeToBlob() const {
    NDrive::NProto::TTagSnapshot protoSnapshot;
    for (const auto& reason : HistoryActionReasons) {
        protoSnapshot.AddHistoryActionReasons(ToString(reason));
    }
    if (Meta.IsDefined()) {
        protoSnapshot.SetMeta(Meta.GetStringRobust());
    }
    return TBlob::FromString(protoSnapshot.SerializeAsString());
}

bool TTagSnapshot::DoDeserializeFromBlob(const TBlob& data) {
    NDrive::NProto::TTagSnapshot protoSnapshot;
    if (!protoSnapshot.ParseFromArray(data.AsCharPtr(), data.Size())) {
        return false;
    }
    for (auto protoReason : protoSnapshot.GetHistoryActionReasons()) {
        EActionReason reason;
        if (!TryFromString(protoReason, reason)) {
            return false;
        }
        HistoryActionReasons.emplace(reason);
    }
    if (protoSnapshot.HasMeta() && !NJson::ReadJsonFastTree(protoSnapshot.GetMeta(), &Meta)) {
        return false;
    }
    return true;
}

NJson::TJsonValue TTagSnapshot::DoSerializeToJson() const {
    NJson::TJsonValue result;
    NJson::InsertField(result, "history_action_reasons", HistoryActionReasons);
    if (Meta.IsDefined()) {
        NJson::InsertField(result, "meta", Meta);
    }
    return result;
}

bool TTagSnapshot::DoDeserializeFromJson(const NJson::TJsonValue& jsonValue) {
    return NJson::ParseField(jsonValue, "history_action_reasons", HistoryActionReasons)
        && NJson::ParseField(jsonValue, "meta", Meta);
}
