#pragma once

#include "abstract.h"

#include <drive/backend/database/history/event.h>

#include <rtline/util/types/accessor.h>

#include <util/memory/blob.h>

class TTagSnapshot: public NDrive::IObjectSnapshot {
public:
    enum class EActionReason {
        UserUnsubscribedFromCommunitation /* "unsubscribed_from_communication" */,
        UndefinedSubscriptionStatus /* "undefined_subscription_status" */,
        LandingAccepted /* "landing_accepted" */,
        NotificationSent /* "notification_sent" */,
        NotificationTooOld /* "notification_too_old" */,
        NotificationDisabled /* "notification_disabled" */,
        NotificationError /* "notification_error" */,
        WrongUser /* "wrong_user" */,
        DeletedUser /* "deleted_user" */,
        Unknown /* "unknown" */
    };

private:
    static TFactory::TRegistrator<TTagSnapshot> Registrator;
    R_READONLY(TSet<EActionReason>, HistoryActionReasons);
    R_FIELD(NJson::TJsonValue, Meta);

public:
    TTagSnapshot() = default;

    TTagSnapshot(const EActionReason reason) {
        AddHistoryActionReason(reason);
    }

    void AddHistoryActionReason(EActionReason reason);
    virtual TString GetTypeName() const override;

private:
    virtual TBlob DoSerializeToBlob() const override;
    virtual bool DoDeserializeFromBlob(const TBlob& data) override;
    virtual NJson::TJsonValue DoSerializeToJson() const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& jsonValue) override;
};
