#include "common.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

TString TDistributingBlockEvent::GetUrl() const {
    return UserId + "/" + Type + "/" + ToString(Timestamp.MicroSeconds());
}

THolder<IDistributingBlockEventsStorageConfig> IDistributingBlockEventsStorageConfig::ConstructConfig(const TYandexConfig::Section& section) {
    const TYandexConfig::Directives& dir = section.GetDirectives();
    TString type;
    dir.GetValue("Type", type);
    THolder<IDistributingBlockEventsStorageConfig> config{TFactory::Construct(type)};
    AssertCorrectConfig(!!config, "Incorrect DistributingBlockEventsStorageConfig type: '%s'", type.data());
    config->Init(section);
    return config;
}
