#pragma once

#include <rtline/util/types/accessor.h>

#include <library/cpp/object_factory/object_factory.h>
#include <library/cpp/threading/future/core/future.h>
#include <library/cpp/yconf/conf.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NDrive {
    class IServer;
    class TEntitySession;
}

class TDistributingBlockEvent {
public:
    using TPtr = TAtomicSharedPtr<TDistributingBlockEvent>;

public:
    TString GetUrl() const;

private:
    R_FIELD(TString, Type);
    R_FIELD(TString, UserId);
    R_FIELD(TInstant, Timestamp);
    R_FIELD(ui32, ShowsCount, 1);
};


class IDistributingBlockEventsStorage;

class IDistributingBlockEventsStorageConfig {
protected:
    using TFactory = NObjectFactory::TObjectFactory<IDistributingBlockEventsStorageConfig, TString>;

public:
    virtual ~IDistributingBlockEventsStorageConfig() = default;
    virtual THolder<IDistributingBlockEventsStorage> BuildStorage(const NDrive::IServer& server) const = 0;
    static THolder<IDistributingBlockEventsStorageConfig> ConstructConfig(const TYandexConfig::Section& section);

private:
    virtual void Init(const TYandexConfig::Section& section) = 0;
};

class IDistributingBlockEventsStorage {
public:
    virtual ~IDistributingBlockEventsStorage() = default;
    // TODO(cezarnik): pointless to return future with stored event; return void instead
    virtual NThreading::TFuture<TDistributingBlockEvent::TPtr> Store(TDistributingBlockEvent::TPtr event, NDrive::TEntitySession* session) const = 0;
    virtual NThreading::TFuture<TVector<TDistributingBlockEvent::TPtr>> Retrieve(const TString& userId) const = 0;
};
