#include "local.h"

void TLocalDistributingBlockEventsStorageConfig::Init(const TYandexConfig::Section& /* section */) {
}

THolder<IDistributingBlockEventsStorage> TLocalDistributingBlockEventsStorageConfig::BuildStorage(const NDrive::IServer& /* server */) const {
    return MakeHolder<TLocalDistributingBlockEventsStorage>();
}

IDistributingBlockEventsStorageConfig::TFactory::TRegistrator<TLocalDistributingBlockEventsStorageConfig> TLocalDistributingBlockEventsStorageConfig::Registrator("local");

NThreading::TFuture<TDistributingBlockEvent::TPtr> TLocalDistributingBlockEventsStorage::Store(TDistributingBlockEvent::TPtr event, NDrive::TEntitySession* /* session */) const {
    TWriteGuard g(Mutex);
    Storage[event->GetUserId()].push_back(event);
    return NThreading::MakeFuture(event);
}

NThreading::TFuture<TVector<TDistributingBlockEvent::TPtr>> TLocalDistributingBlockEventsStorage::Retrieve(const TString& userId) const {
    TReadGuard g(Mutex);
    if (auto it = Storage.find(userId); it != Storage.end()) {
        return NThreading::MakeFuture(it->second);
    }
    return NThreading::MakeFuture(TVector<TDistributingBlockEvent::TPtr>{});
}
