#pragma once

#include "common.h"

class TLocalDistributingBlockEventsStorageConfig : public IDistributingBlockEventsStorageConfig {
private:
    virtual void Init(const TYandexConfig::Section& section) override;
    virtual THolder<IDistributingBlockEventsStorage> BuildStorage(const NDrive::IServer& server) const override;

private:
    static TFactory::TRegistrator<TLocalDistributingBlockEventsStorageConfig> Registrator;
};


class TLocalDistributingBlockEventsStorage : public IDistributingBlockEventsStorage {
private:
    virtual NThreading::TFuture<TDistributingBlockEvent::TPtr> Store(TDistributingBlockEvent::TPtr event, NDrive::TEntitySession* session) const override;
    virtual NThreading::TFuture<TVector<TDistributingBlockEvent::TPtr>> Retrieve(const TString& userId) const override;

private:
    mutable TMap<TString, TVector<TDistributingBlockEvent::TPtr>> Storage;
    mutable TRWMutex Mutex;
};
