#pragma once

#include <drive/backend/doc_packages/template.h>

#include <drive/backend/database/attachment_context.h>

class TCarTemplate: public ITemplateDataByStorage<TCarRegistryDocument::EFields> {
public:
    enum EInput {
        CarId /* "car_id" */,
        DocDate /* "car_doc_date" */,
    };

public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override {
        TInstant carDocDate = Now();
        if (!NJson::ParseField(json, ToString(EInput::DocDate), carDocDate, false)) {
            errors.AddMessage("ui_errors", "Неизвестный формат даты: " + json[ToString(EInput::DocDate)].GetString());
            return false;
        }
        return Fetch(json[ToString(EInput::CarId)].GetString(), carDocDate, server, errors);
    }

    bool Fetch(const TString& carId, TInstant carDocDate, const NDrive::IServer& server, TMessagesCollector& errors);

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        TVector<TString> result;
        for (auto&& var : GetEnumAllValues<EInput>()) {
            result.push_back(ToString(var));
        }
        return result;
    }

    virtual void AddInputsToScheme(const IServerBase& server, NDrive::TScheme& scheme) const override;

    void AddParameter(EOutput parameter, const NJson::TJsonValue& json);

private:
    static TSet<EOutput> DateParameters;
    static TString Name;
    static TFactory::TRegistrator<TCarTemplate> Registrator;
};
